% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.table}
\alias{h2o.table}
\alias{table.Frame}
\title{Cross Tabulation and Table Creation in H2O}
\usage{
h2o.table(x, y = NULL)

table.Frame(x, y = NULL)
}
\arguments{
\item{x}{An H2O Frame object with at most two columns.}

\item{y}{An H2O Frame similar to x, or \code{NULL}.}
}
\value{
Returns a tabulated Frame object.
}
\description{
Uses the cross-classifying factors to build a table of counts at each combination of factor levels.
}
\examples{
\donttest{
library(h2o)
h2o.init()
prosPath <- system.file("extdata", "prostate.csv", package="h2o")
prostate.hex <- h2o.uploadFile(path = prosPath, destination_frame = "prostate.hex")
summary(prostate.hex)

# Counts of the ages of all patients
head(h2o.table(prostate.hex[,3]))
h2o.table(prostate.hex[,3])

# Two-way table of ages (rows) and race (cols) of all patients
head(h2o.table(prostate.hex[,c(3,4)]))
h2o.table(prostate.hex[,c(3,4)])
}
}

