% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h3_algorithms.R
\name{polygon_to_cells}
\alias{polygon_to_cells}
\title{Get H3 cell index within a polygon}
\usage{
polygon_to_cells(geometry = NULL, res = NULL, simple = TRUE)
}
\arguments{
\item{geometry}{\code{sf} object of type \code{POLYGON} or
\code{MULTIPOLYGON}.}

\item{res}{Integer; Desired H3 resolution. See
\url{https://h3geo.org/docs/core-library/restable/} for allowable values and related dimensions.}

\item{simple}{Logical; whether to return a vector of outputs or an sf object
containing both inputs and outputs.}
}
\value{
By default, a list of \code{length(h3_address)}. Each list element
  contains a character vector of H3 cell indices belonging to that geometry.
  A result of NA indicates that no H3 cell indices of the chosen resolution
  are centered over the geometry.
}
\description{
This function returns all the H3 cell indexes within the supplied polygon
geometry.
}
\note{
This function will be slow with a large number of polygons, and/or
  polygons that are large relative to the hexagon area at the chosen
  resolution. A message is printed to console where the total input area is
  (roughly) > 100000x the area of the chosen H3 resolution.
}
\examples{
# Which level 5 H3 cell indices have centers inside County Ashe, NC?
nc <- sf::st_read(system.file("shape/nc.shp", package="sf"), quiet = TRUE)
nc1 <- nc[1, ]
fillers <- polygon_to_cells(geometry = nc1, res = 5)
}
