% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igt_vpp.R
\name{igt_vpp}
\alias{igt_vpp}
\title{Iowa Gambling Task (Worthy et al., 2014)}
\usage{
igt_vpp(data = NULL, niter = 3000, nwarmup = 1000, nchain = 1,
  ncore = 1, nthin = 1, inits = "random", indPars = "mean",
  payscale = 100, saveDir = NULL, email = NULL)
}
\arguments{
\item{data}{A .txt file containing the data to be modeled. Data columns should be labelled as follows: "subjID", "deck", "gain", and "loss". See \bold{Details} below for more information.}

\item{niter}{Number of iterations, including warm-up.}

\item{nwarmup}{Number of iterations used for warm-up only.}

\item{nchain}{Number of chains to be run.}

\item{ncore}{Integer value specifying how many CPUs to run the MCMC sampling on. Defaults to 1.}

\item{nthin}{Every \code{i == nthin} sample will be used to generate the posterior distribution. Defaults to 1. A higher number can be used when auto-correlation within the MCMC sampling is high.}

\item{inits}{Character value specifying how the initial values should be generated. Options are "fixed" or "random" or your own initial values.}

\item{indPars}{Character value specifying how to summarize individual parameters. Current options are: "mean", "median", or "mode".}

\item{payscale}{Raw payoffs within data are divided by this number. Used for scaling data. Defaults to 100}

\item{saveDir}{Path to directory where .RData file of model output (\code{modelData}) can be saved. Leave blank if not interested.}

\item{email}{Character value containing email address to send notification of completion. Leave blank if not interested.}
}
\value{
\code{modelData}  A class \code{'hBayesDM'} object with the following components:
\describe{
 \item{\code{model}}{Character string with the name of the model ("igt_vpp").}
 \item{\code{allIndPars}}{\code{'data.frame'} containing the summarized parameter 
   values (as specified by \code{'indPars'}) for each subject.}
 \item{\code{parVals}}{A \code{'list'} where each element contains posterior samples
   over different model parameters. }
 \item{\code{fit}}{A class \code{'stanfit'} object containing the fitted model.}
}
}
\description{
Hierarchical Bayesian Modeling of the Iowa Gambling Task using the following parameters: "A" (learning rate), "alpha" (outcome sensitivity), "cons" (response consistency), "lambda" (loss aversion), "epP" (gain impact), "epN" (loss impact), "K" (decay rate), and "w" (RL weight).

\strong{MODEL:}
Value-Plus_Perseverance (Worthy et al., 2014, Frontiers in Psychology)
}
\details{
This section describes some of the function arguments in greater detail.

\strong{data} should be assigned a character value specifying the full path and name of the file, including the file extension 
(e.g. ".txt"), that contains the behavioral data of all subjects of interest for the current analysis. 
The file should be a text (.txt) file whose rows represent trial-by-trial observations and columns 
represent variables. For the Iowa Gambling Task, there should be four columns of data with the labels 
"subjID", "deck", "gain", and "loss". It is not necessary for the columns to be in this particular order, 
however it is necessary that they be labelled correctly and contain the information below:
\describe{
 \item{\code{"subjID"}}{A unique identifier for each subject within data-set to be analyzed.}
 \item{\code{"deck"}}{A nominal integer representing which deck was chosen within the given trial (e.g. A, B, C, or D == 1, 2, 3, or 4 in the IGT).}
 \item{\code{"gain"}}{A floating number representing the amount of currency won on the given trial (e.g. 50, 50, 100).}
 \item{\code{"loss"}}{A floating number representing the amount of currency lost on the given trial (e.g. 0, -50).}
} 
\strong{*}Note: The data.txt file may contain other columns of data (e.g. "Reaction_Time", "trial_number", etc.), but only the data with the column
names listed above will be used for analysis/modeling. As long as the columns above are present and labelled correctly,
there is no need to remove other miscellaneous data columns.    
 
\strong{nwarmup} is a numerical value that specifies how many MCMC samples should not be stored upon the 
beginning of each chain. For those familiar with Bayesian methods, this value is equivalent to a burn-in sample. 
Due to the nature of MCMC sampling, initial values (where the sampling chain begins) can have a heavy influence 
on the generated posterior distributions. The \strong{nwarmup} argument can be set to a high number in order to curb the 
effects that initial values have on the resulting posteriors.  

\strong{nchain} is a numerical value that specifies how many chains (i.e. independent sampling sequences) should be
used to draw samples from the posterior distribution. Since the posteriors are generated from a sampling 
process, it is good practice to run multiple chains to ensure that a representative posterior is attained. When
sampling is completed, the multiple chains may be checked for convergence with the \code{plot(myModel, type = "trace")}
command. The chains should resemble a "furry caterpillar". 

\strong{nthin} is a numerical value that specifies the "skipping" behavior of the MCMC samples being chosen 
to generate the posterior distributions. By default, \strong{nthin} is equal to 1, hence every sample is used to 
generate the posterior.
}
\examples{
\dontrun{
# Run the model and store results in "output"
output <- igt_vpp("example", 2000, 1000, 3, 3)

# Plot the posterior distributions of the hyper-parameters
plot(output)

# Show the WAIC and LOOIC model fit estimates 
printFit(output)
}
}

