% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hablar.R
\name{check_df}
\alias{check_df}
\alias{check_duplicates}
\alias{check_na}
\alias{check_irrational}
\alias{check_nan}
\alias{check_inf}
\alias{check_complete_set}
\title{Special checks}
\usage{
check_duplicates(.data, ...)

check_na(.data, ...)

check_irrational(.data, ...)

check_nan(.data, ...)

check_inf(.data, ...)

check_complete_set(.data, ...)
}
\arguments{
\item{.data}{a data frame}

\item{...}{variables that should be considered. If empty, all variables are used.}
}
\value{
TRUE or FALSE
}
\description{
Returns TRUE if data frame have the specified special cases. For example, find_duplicates() returns
TRUE if any rows are duplicates. If variables are passed to the function
then TRUE or FALSE is returned for those variables.
}
\details{
irrational values are Inf and NaN. 'check_complete_set' tests 
if all combinations of elements exists in the data frame.
}
\examples{
\dontrun{
df <- data.frame(a = c("A", NA, "B", "C", "C"),
                 b = c(7, 8, 2, 3, 3),
                 c = c(NA, 1, NaN, 3, 2),
                 stringsAsFactors = FALSE)

# Returns FALSE because there is no duplicates
df \%>\% check_duplicates()

# Returns TRUE because there is duplicates in column a through b
df \%>\% check_duplicates(a:b)

# Returns FALSE because there is no NA column b
df \%>\% check_na(b)

# Returns TRUE because there is no NaN column c
df \%>\% check_nan(c)
}

}
\seealso{
\code{\link{find_in_df}} to return rows instead of TRUE or FALSE. 
\code{vignette("s")}, \code{vignette("hablar")}
}
