% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hvar.R
\name{hvar}
\alias{hvar}
\title{Calculate height variation in cells at different scales}
\usage{
hvar(
  data,
  lvec = NULL,
  parallel = FALSE,
  ncores = (parallel::detectCores() - 1)
)
}
\arguments{
\item{data}{Digital elevation model of class RasterLayer.}

\item{lvec}{Scales to use for calculation.}

\item{parallel}{Logical. Use parallel processing? Note: parallel must be installed.}

\item{ncores}{Number of cores to use when parallel = TRUE.}
}
\value{
A \code{data.frame} containing height ranges of cells at different scales.
}
\description{
This is a helper function used for calculating fractal dimension using the
height variation and standard deviation methods.
}
\examples{

hvar(horseshoe, lvec = c(1, 2, 4, 8))
}
