% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perimeter.R
\name{perimeter}
\alias{perimeter}
\title{Calculate perimeter of a 2D shape}
\usage{
perimeter(data, keep_data = FALSE)
}
\arguments{
\item{data}{A data frame with the first two columns ordered x and y coordinates.}

\item{keep_data}{Logical. Keep lengths of all segments of the perimeter? Defaults to FALSE.}
}
\value{
The perimeter.
}
\description{
Calculates the perimeter of a 2D shape.
}
\examples{
mcap_2d <- mesh_to_2d(mcap)
plot(mcap_2d)

perimeter(mcap_2d)

r <- 1 # radius
circ <- sim_circle(r=r) # simulate xy coordinates for a circle of radius 1
plot(circ, asp=1)
perimeter(circ)

2 * pi * r # Note xy resolution affects output

}
