% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_circle.R
\name{sim_circle}
\alias{sim_circle}
\title{Simulate a circle}
\usage{
sim_circle(r = 1, n = 100, mid = c(0, 0))
}
\arguments{
\item{r}{Radius of the circle (default 1).}

\item{n}{Number of xy coordinates defining the circle (default 100).}

\item{mid}{Mid point of the circle (default 0, 0).}
}
\value{
A data frame of n xy-coordinates.
}
\description{
Simulates xy coordinates for a circle of given radius. Created for package
testing purposes, but might be useful for others.
}
\examples{
circ <- sim_circle()
plot(circ)

circularity(circ)
perimeter(circ)

}
