% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_online.R
\name{construct_onlinemeas_rundir}
\alias{construct_onlinemeas_rundir}
\title{Construct a run directory string for \link{analysis_online}}
\usage{
construct_onlinemeas_rundir(type, beta, L, Time, kappa = 0, mul = 0,
  csw = 0, musigma = 0, mudelta = 0, muh = 0, addon = "",
  debug = FALSE)
}
\arguments{
\item{type}{String. Short identifier for gauge action type. For example, \code{iwa} for Iwasaki gauge action.}

\item{beta}{Numeric. Inverse gauge coupling.}

\item{L}{Integer. Spatial lattice extent.}

\item{Time}{Integer. Temporal lattice extent.}

\item{kappa}{Numeric. Sea quark action hopping parameter.}

\item{mul}{Numeric. Sea light quark twisted mass.}

\item{csw}{Numeric. Sea quark action clover parameter.}

\item{musigma}{Numeric. Sea 1+1 "heavy" average twisted quark mass.}

\item{mudelta}{Numeric. Sea 1+1 "heavy" splitting twisted quark mass.}

\item{muh}{Numeric. In case of \code{n_f=2+2} run, "heavy" twisted quark mass.}

\item{addon}{String. Arbitratry string which will be suffixed to the constructed run directory.}

\item{debug}{Boolean. If \code{TRUE}, the constructed directory name is printed to screen.}
}
\value{
String. Directory name constructed out of the various function parameters. See source code for details.
}
\description{
Construct a run directory string for \link{analysis_online}
}
