% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readutils.R
\name{getorderedconfignumbers}
\alias{getorderedconfignumbers}
\title{Creates an ordered vector of gauge config file numbers}
\usage{
getorderedconfignumbers(path = "./", basename = "onlinemeas",
  last.digits = 4, ending = "")
}
\arguments{
\item{path}{the path to be searched}

\item{basename}{the basename of the files}

\item{last.digits}{the number of last characters in each filename to be used
for ordering the list.}

\item{ending}{the file extension after the digits.}
}
\value{
returns the ordered list of gauge config numbers as a numeric vector.
}
\description{
These functions generate an ordered list of config
numbers by using a path and a basename and '*'.
}
\details{
All filenames are assumend to have equal length.
}
\examples{
confignumbers <- getorderedconfignumbers(path=paste0(system.file(package="hadron"), "/extdata/"),
                               basename="testfile", last.digits=3, ending=".dat")
confignumbers
}
\seealso{
\code{\link{readcmidatafiles}}, \code{\link{extract.obs}}
}
\author{
Carsten Urbach, \email{curbach@gmx.de}
}
\keyword{file}
