% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeTemporal.cf.R
\name{old_removeTemporal.cf}
\alias{old_removeTemporal.cf}
\title{Remove temporal states}
\usage{
old_removeTemporal.cf(cf, single.cf1, single.cf2, p1 = c(0, 0, 0),
  p2 = c(0, 0, 0), L, lat.disp = TRUE, weight.cosh = FALSE, deltat = 1)
}
\arguments{
\item{cf}{Object of type \code{cf}, two-to-two particle correlation function which
shall be weighted and shifted. It must be a correlation function in the
frame \eqn{p_1 + p_2}.}

\item{single.cf1, single.cf2}{Object of type \code{effectivemassfit} or \code{matrixfit}
which contains the one particle mass in the rest frame.

If \code{single.cf2} is missing, then the mass given as \code{single.cf1} is used as
well. This is sensibly done when one scatters identical particles. But be
careful: Even when \code{single.cf2} is missing, the \code{p2} is \emph{not} automatically
copied from \code{p1}.

In case \code{single.cf1} is missing, no weighting is performed. Instead it is
assumed that the user only wants to have a simple shifting. Then this
function just calls \code{takeTimeDiff.cf}.}

\item{p1, p2}{Integer vector with three elements, containing the momenta that
the one particle mass should be boosted to.}

\item{L}{Integer, spatial extent of the lattice.}

\item{lat.disp}{Logical, true when the lattice dispersion relation shall be
used, otherwise continuum dispersion relation.}

\item{weight.cosh}{Logical, If single.cf1 is a pure cosh, the leading two
thermal states also may be expressed as a cosh. If \code{weight.cosh} is set,
they are removed simultaneously.}

\item{deltat}{Integer. Time shift value.}
}
\value{
Returns an object of class \code{cf}, see \link{cf}.
}
\description{
Performs weighting and shifting in the rest and moving frames.
}
