% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ris_reader.R
\name{ris_reader}
\alias{ris_reader}
\title{ris reader}
\usage{
ris_reader(x)
}
\arguments{
\item{x}{(character) a file path or string}
}
\value{
an object of class \code{handl}; see \link{handl} for more
}
\description{
ris reader
}
\examples{
z <- system.file('extdata/crossref.ris', package = "handlr")
ris_reader(z)

z <- system.file('extdata/peerj.ris', package = "handlr")
ris_reader(z)

z <- system.file('extdata/plos.ris', package = "handlr")
ris_reader(z)

# from a string
z <- system.file('extdata/crossref.ris', package = "handlr")
my_string <- ris_writer(ris_reader(z))
class(my_string)
ris_reader(my_string)

# many
z <- system.file('extdata/multiple-eg.ris', package = "handlr")
ris_reader(z)
}
\references{
RIS tags https://en.wikipedia.org/wiki/RIS_(file_format)
}
\seealso{
Other readers: \code{\link{bibtex_reader}},
  \code{\link{citeproc_reader}},
  \code{\link{codemeta_reader}}

Other ris: \code{\link{ris_writer}}
}
\concept{readers}
\concept{ris}
