% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcd_page_hinkley.R
\name{hcd_page_hinkley}
\alias{hcd_page_hinkley}
\title{Adapted Page Hinkley method}
\usage{
hcd_page_hinkley(
  min_instances = 30,
  delta = 0.005,
  threshold = 50,
  alpha = 1 - 1e-04
)
}
\arguments{
\item{min_instances}{The minimum number of instances before detecting change}

\item{delta}{The delta factor for the Page Hinkley test}

\item{threshold}{The change detection threshold (lambda)}

\item{alpha}{The forgetting factor, used to weight the observed value and the mean}
}
\value{
\code{hcp_page_hinkley} object
}
\description{
Change-point detection method works by computing the observed values and their mean up to the current moment \url{doi:10.2307/2333009}.
}
\examples{
library("daltoolbox")

n <- 100  # size of each segment
serie1 <- c(sin((1:n)/pi), 2*sin((1:n)/pi), 10 + sin((1:n)/pi),
           10-10/n*(1:n)+sin((1:n)/pi)/2, sin((1:n)/pi)/2)
serie2 <- 2*c(sin((1:n)/pi), 2*sin((1:n)/pi), 10 + sin((1:n)/pi),
           10-10/n*(1:n)+sin((1:n)/pi)/2, sin((1:n)/pi)/2)
data <- data.frame(serie1, serie2)#'
event <- rep(FALSE, nrow(data))

model <- fit(hcd_page_hinkley(threshold=3), data)
detection <- detect(model, data)
print(detection[(detection$event),])

}
