% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_instruments.R
\name{match_instruments}
\alias{match_instruments}
\title{Match Instruments Function}
\usage{
match_instruments(instruments, is_negate = TRUE)
}
\arguments{
\item{instruments}{A list of instruments to be matched.}

\item{is_negate}{A boolean value to toggle question negation. Default is TRUE.}
}
\value{
A list of matched instruments returned from the 'Harmony Data API'.
}
\description{
This function takes a list of instruments, converts it to a format acceptable by the database,
and matches the instruments using the 'Harmony Data API'. It returns the matched instruments.
}
\examples{
\donttest{



instrument_A <- create_instrument_from_list(list(
  "How old are you?",
  "What is your gender?"
))

instrument_B <- create_instrument_from_list(list(
  "Do you smoke?"
))

instruments <- list(instrument_A, instrument_B)

matched_instruments <- match_instruments(instruments)
}

}
\author{
Ulster University [cph]
}
