% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/labelled.R
\name{labelled}
\alias{as_factor.labelled}
\alias{labelled}
\alias{zap_labels}
\title{Create a labelled vector.}
\usage{
labelled(x, labels)

\method{as_factor}{labelled}(x, levels = c("labels", "values"),
  ordered = FALSE, ...)

zap_labels(x)
}
\arguments{
\item{x}{A vector to label. Must be either numeric (integer or double) or
character.}

\item{labels}{A named vector. The vector should be the same type as
x. Unlike factors, labels don't need to be exhaustive: only a fraction
of the values might be labelled.}

\item{levels}{When coercing a labelled character vector to a factor, you
can choose whether to use the labels or the values as the factor levels.}

\item{ordered}{If \code{TRUE} for ordinal factors, \code{FALSE} (the default)
for nominal factors.}

\item{...}{Ignored}
}
\description{
A labelled vector is a common data structure in other statistical
environments. This class makes it possible to import such labelled vectors
in to without loss of fidelity. This class provides few methods, as I
expect you'll coerce to a standard R class (e.g. a \code{\link{factor}})
soon after importing.
}
\examples{
s1 <- labelled(c("M", "M", "F"), c(Male = "M", Female = "F"))
s2 <- labelled(c(1, 1, 2), c(Male = 1, Female = 2))

# Unfortunately it's not possible to make as.factor work for labelled objects
# so instead use as_factor. This works for all types of labelled vectors.
as_factor(s1)
as_factor(s1, labels = "values")
as_factor(s2)

# Often when you have a partially labelled numeric vector, labelled values
# are special types of missing. Use XXX to replace labels with missing
# values
x <- labelled(c(1, 2, 1, 2, 10, 9), c(Unknown = 9, Refused = 10))
zap_labels(x)
}

