% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haven.R
\name{read_spss}
\alias{read_spss}
\alias{read_sav}
\alias{read_por}
\alias{write_sav}
\title{Read SPSS (\code{.sav}, \code{.zsav}, \code{.por}) files. Write \code{.sav} and \code{.zsav} files.}
\usage{
read_sav(file, encoding = NULL, user_na = FALSE)

read_por(file, user_na = FALSE)

write_sav(data, path, compress = FALSE)

read_spss(file, user_na = FALSE)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data
(either a single string or a raw vector).

Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will
be automatically uncompressed. Files starting with \code{http://},
\code{https://}, \code{ftp://}, or \code{ftps://} will be automatically
downloaded. Remote gz files can also be automatically downloaded and
decompressed.

Literal data is most useful for examples and tests. It must contain at
least one new line to be recognised as data (instead of a path).}

\item{encoding}{The character encoding used for the file. The default,
\code{NULL}, use the encoding specified in the file, but sometimes this
value is incorrect and it is useful to be able to override it.}

\item{user_na}{If \code{TRUE} variables with user defined missing will
be read into \code{\link[=labelled_spss]{labelled_spss()}} objects. If \code{FALSE}, the
default, user-defined missings will be converted to \code{NA}.}

\item{data}{Data frame to write.}

\item{path}{Path to a file where the data will be written.}

\item{compress}{If \code{TRUE}, will compress the file, resulting in a \code{.zsav}
file.}
}
\value{
A tibble, data frame variant with nice defaults.

Variable labels are stored in the "label" attribute of each variable.
It is not printed on the console, but the RStudio viewer will show it.

\code{write_sav()} returns the input \code{data} invisibly.
}
\description{
\code{read_sav()} reads both \code{.sav} and \code{.zsav} files; \code{write_sav()} creates
\code{.zsav} files when \code{compress = TRUE}. \code{read_por()} reads \code{.por} files.
\code{read_spss()} uses either \code{read_por()} or \code{read_sav()} based on the
file extension.
}
\details{
Currently haven can read and write logical, integer, numeric, character
and factors. See \code{\link[=labelled_spss]{labelled_spss()}} for how labelled variables in
SPSS are handled in R.
}
\examples{
path <- system.file("examples", "iris.sav", package = "haven")
read_sav(path)

tmp <- tempfile(fileext = ".sav")
write_sav(mtcars, tmp)
read_sav(tmp)
}
