% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MTDmodel-methods.R
\name{MTD-methods}
\alias{MTD-methods}
\alias{print.MTD}
\alias{summary.MTD}
\alias{print.summary.MTD}
\alias{coef.MTD}
\alias{logLik.MTD}
\title{Methods for objects of class \code{"MTD"}}
\usage{
\method{print}{MTD}(x, ...)

\method{summary}{MTD}(object, ...)

\method{print}{summary.MTD}(x, ...)

\method{coef}{MTD}(object, ...)

\method{logLik}{MTD}(object, X, ...)
}
\arguments{
\item{x}{An object of class \code{"MTD"} or \code{"summary.MTD"},
depending on the method.}

\item{...}{Further arguments passed to or from other methods (ignored).}

\item{object}{An object of class \code{"MTD"}.}

\item{X}{A vector or single-column data frame containing an MTD chain sample
(values must be in the model's state space).}
}
\value{
\describe{
\item{\code{print.MTD}}{Invisibly returns the \code{"MTD"} object, after
displaying its relevant lag set and state space.}
\item{\code{summary.MTD}}{An object of class \code{"summary.MTD"} with fields:
\code{order}, \code{states}, \code{lags}, \code{indep},
\code{lambdas}, \code{p0} (or \code{NULL}),
\code{P_dim}, and \code{P_head}.}
\item{\code{print.summary.MTD}}{Invisibly returns the
\code{"summary.MTD"} object after printing its contents.}
\item{\code{coef.MTD}}{A list with model parameters:
\code{lambdas}, \code{pj}, and \code{p0}.}
\item{\code{logLik.MTD}}{An object of class \code{"logLik"} with attributes
\code{nobs} (number of transitions) and \code{df} (free parameters),
honoring model constraints such as \code{single_matrix} and the independent
component (\code{indep_part}).}
}
}
\description{
Printing, summarizing, and coefficient-extraction methods for Mixture
Transition Distribution (MTD) model objects.
}
\details{
\code{print.MTD()} displays the relevant lag set (shown as negative integers)
and the state space. For a detailed overview including mixture weights and a
compact preview of the global transition matrix \eqn{P}, use \code{summary()}.
}
\examples{
\dontrun{
set.seed(1)
m <- MTDmodel(Lambda = c(1, 3), A = c(0, 1), lam0 = 0.05)

print(m)       # compact display: lags (Z^-) and state space
s <- summary(m)
print(s)

coef(m)        # list(lambdas = ..., pj = ..., p0 = ...)
transitP(m)    # global transition matrix P
pj(m); p0(m); lambdas(m); lags(m); Lambda(m); states(m)
}

}
\seealso{
\code{\link{MTDmodel}}, \code{\link{MTDest}},
\code{\link{transitP}}, \code{\link{lambdas}}, \code{\link{pj}},
\code{\link{p0}}, \code{\link{lags}}, \code{\link{Lambda}}, \code{\link{states}},
\code{\link{summary.MTDest}}, \code{\link{coef.MTDest}},
\code{\link{oscillation}}, \code{\link{perfectSample}},
\code{\link[stats]{logLik}}
}
