% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R
\name{coef.mixturecure}
\alias{coef.mixturecure}
\title{Extract model coefficients from a fitted mixture cure object}
\usage{
\method{coef}{mixturecure}(object, model.select = "AIC", ...)
}
\arguments{
\item{object}{a \code{mixturecure} object resulting from \code{curegmifs}, \code{cureem}, \code{cv_curegmifs}, or \code{cv_cureem}.}

\item{model.select}{for models fit using \code{curegmifs} or \code{cureem} any step along the solution path can be selected. The default is \code{model.select = "AIC"} which calculates the predicted values using the coefficients from the model having the lowest AIC. Other options are \code{model.select = "mAIC"} for the modified AIC,  \code{model.select = "cAIC"} for the corrected AIC, \code{model.select = "BIC"}, \code{model.select = "mBIC"} for the modified BIC, \code{model.select = "EBIC"} for the extended BIC, \code{model.select = "logLik"} for the step that maximizes the log-likelihood, or any numeric value from the solution path. This option has no effect for objects fit using \code{cv_curegmifs} or \code{cv_cureem}.}

\item{...}{other arguments.}
}
\value{
a list of estimated parameters extracted from the model object using the model selection criterion
}
\description{
\code{coef.mixturecure} is a generic function which extracts the model coefficients from a fitted mixture cure model object fit using \code{curegmifs}, \code{cureem}, \code{cv_curegmifs}, or \code{cv_cureem}.
}
\examples{
library(survival)
set.seed(1234)
temp <- generate_cure_data(N = 100, J = 10, nTrue = 10, A = 1.8)
training <- temp$Training
fit <- curegmifs(Surv(Time, Censor) ~ .,
                      data = training, x.latency = training,
                      model = "weibull", thresh = 1e-4, maxit = 2000, epsilon = 0.01,
                      verbose = FALSE)
coef(fit)
}
\seealso{
\code{\link{curegmifs}}, \code{\link{cureem}}, \code{\link{summary.mixturecure}}, \code{\link{plot.mixturecure}}, \code{\link{predict.mixturecure}}
}
\keyword{methods}
