% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.mixturecure}
\alias{summary.mixturecure}
\title{Summarize a Fitted Mixture Cure Object.}
\usage{
\method{summary}{mixturecure}(object, ...)
}
\arguments{
\item{object}{a \code{mixturecure} object resulting from \code{curegmifs}, \code{cureem}, \code{cv_curegmifs}, or \code{cv_cureem}.}

\item{...}{other arguments.}
}
\value{
prints the following items extracted from the object fit using \code{curegmifs} or \code{cureem}: the step and value that maximizes the log-likelihood; the step and value that minimizes the AIC, modified AIC (mAIC), corrected AIC (cAIC), BIC, modified BIC (mBIC), and extended BIC (EBIC). Returns log-likelihood, AIC, and BIC if the object was fit using \code{cv_curegmifs} or \code{cv_cureem} at the optimal cross-validated values if no FDR control; the number of non-zero incidence and latency variables is returned when cross-validation is used together with FDR control.
}
\description{
\code{summary} method for a mixturecure object fit using \code{curegmifs}, \code{cureem}, \code{cv_curegmifs}, or \code{cv_cureem}.
}
\examples{
library(survival)
set.seed(1234)
temp <- generate_cure_data(N = 100, J = 10, nTrue = 10, A = 1.8)
training <- temp$Training
fit <- curegmifs(Surv(Time, Censor) ~ .,
                       data = training, x.latency = training,
                       model = "weibull", thresh = 1e-4, maxit = 2000,
                       epsilon = 0.01, verbose = FALSE)
summary(fit)
}
\seealso{
\code{\link{curegmifs}}, \code{\link{cureem}}, \code{\link{coef.mixturecure}}, \code{\link{plot.mixturecure}}, \code{\link{predict.mixturecure}}
}
\keyword{methods}
