% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEPA.R
\name{tsSEPA}
\alias{tsSEPA}
\title{Interface for the MOPEX database of Daily Time Series}
\usage{
tsSEPA(stationID, plotOption = FALSE, timeExtent = NULL)
}
\arguments{
\item{stationID}{hydrometric reference number (string)}

\item{plotOption}{boolean to define whether to plot the results. By default this is set to TRUE.}

\item{timeExtent}{is a vector of dates and times for which the data should be retrieved}
}
\value{
The function returns river level data in a zoo object.
}
\description{
This function extract the dataset containing daily rainfall and streamflow discharge at one of the MOPEX locations.
}
\examples{
\dontrun{
  sampleID <- catalogueSEPA()$stationId[1]
  sampleTS <- tsSEPA(stationID = sampleID, plotOption = TRUE)
}

}
\author{
Claudia Vitolo
}
