// (c) The HDF Group
#ifndef H5HLprivate_H
#define H5HLprivate_H
#include "H5private.h"
#include "H5ACprivate.h"
#include "H5Fprivate.h"
#define H5HL_ALIGN(X) ((((unsigned)X) + 7) & (unsigned)(~0x07))
#define H5HL_SIZEOF_FREE(F)                                                                                  \
    H5HL_ALIGN(H5F_SIZEOF_SIZE(F) +                                           \
               H5F_SIZEOF_SIZE(F))
typedef struct H5HL_t H5HL_t;
H5_DLL herr_t  H5HL_create(H5F_t *f, size_t size_hint, haddr_t *addr);
H5_DLL herr_t  H5HL_delete(H5F_t *f, haddr_t addr);
H5_DLL size_t  H5HL_heap_get_size(const H5HL_t *heap);
H5_DLL herr_t  H5HL_get_size(H5F_t *f, haddr_t addr, size_t *size);
H5_DLL herr_t  H5HL_heapsize(H5F_t *f, haddr_t addr, hsize_t *heap_size);
H5_DLL herr_t  H5HL_insert(H5F_t *f, H5HL_t *heap, size_t size, const void *buf, size_t *offset);
H5_DLL void   *H5HL_offset_into(const H5HL_t *heap, size_t offset);
H5_DLL H5HL_t *H5HL_protect(H5F_t *f, haddr_t addr, unsigned flags);
H5_DLL herr_t  H5HL_remove(H5F_t *f, H5HL_t *heap, size_t offset, size_t size);
H5_DLL herr_t  H5HL_unprotect(H5HL_t *heap);
H5_DLL herr_t H5HL_debug(H5F_t *f, haddr_t addr, FILE *stream, int indent, int fwidth);
#endif
