/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "H5VLmodule.h" 

#include "H5private.h" 
#include "H5VLpkg.h"   

size_t
H5VL_obj_get_rc(const H5VL_object_t *vol_obj)
{
    
    FUNC_ENTER_NOAPI_NOINIT_NOERR

    assert(vol_obj);

    FUNC_LEAVE_NOAPI(vol_obj->rc)
} 

H5VL_connector_t *
H5VL_obj_get_connector(const H5VL_object_t *vol_obj)
{
    
    FUNC_ENTER_NOAPI_NOINIT_NOERR

    assert(vol_obj);

    FUNC_LEAVE_NOAPI(vol_obj->connector)
} 

void *
H5VL_obj_get_data(const H5VL_object_t *vol_obj)
{
    
    FUNC_ENTER_NOAPI_NOINIT_NOERR

    assert(vol_obj);

    FUNC_LEAVE_NOAPI(vol_obj->data)
} 

void
H5VL_obj_reset_data(H5VL_object_t *vol_obj)
{
    
    FUNC_ENTER_NOAPI_NOINIT_NOERR

    assert(vol_obj);

    vol_obj->data = NULL;

    FUNC_LEAVE_NOAPI_VOID
} 
