% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_3_model_method.R
\name{predict.hdnom.model}
\alias{predict.hdnom.model}
\title{Make predictions from high-dimensional Cox models}
\usage{
\method{predict}{hdnom.model}(object, x, y, newx, pred.at, ...)
}
\arguments{
\item{object}{Model object.}

\item{x}{Data matrix used to fit the model.}

\item{y}{Response matrix made with \code{\link[survival]{Surv}}.}

\item{newx}{Matrix (with named columns) of new values for \code{x}
at which predictions are to be made.}

\item{pred.at}{Time point at which prediction should take place.}

\item{...}{Other parameters (not used).}
}
\value{
A \code{nrow(newx) x length(pred.at)} matrix containing
overall survival probablity.
}
\description{
Predict overall survival probability at certain time points
from fitted Cox models.
}
\examples{
data("smart")
x <- as.matrix(smart[, -c(1, 2)])
time <- smart$TEVENT
event <- smart$EVENT
y <- survival::Surv(time, event)

fit <- fit_lasso(x, y, nfolds = 5, rule = "lambda.1se", seed = 11)
predict(fit, x, y, newx = x[101:105, ], pred.at = 1:10 * 365)
}
