
<!-- README.md is generated from README.Rmd. Please edit that file -->

# hdnom <img src="man/figures/logo.png" align="right" width="120" />

<!-- badges: start -->

[![R-CMD-check](https://github.com/nanxstats/hdnom/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/nanxstats/hdnom/actions/workflows/R-CMD-check.yaml)
[![CRAN
Version](https://www.r-pkg.org/badges/version/hdnom)](https://cran.r-project.org/package=hdnom)
[![Downloads from the RStudio CRAN
mirror](https://cranlogs.r-pkg.org/badges/hdnom)](https://cranlogs.r-pkg.org/badges/hdnom)
<!-- badges: end -->

`hdnom` creates nomogram visualizations for penalized Cox regression
models, with the support of reproducible survival model building,
validation, calibration, and comparison for high-dimensional data.

## Installation

You can install `hdnom` from CRAN:

``` r
install.packages("hdnom")
```

Or try the development version on GitHub:

``` r
remotes::install_github("nanxstats/hdnom")
```

Browse [the vignettes](https://nanx.me/hdnom/articles/) to get started.

## Gallery

### Nomogram

<img src="man/figures/README-nomogram-1.png" width="100%" style="display: block; margin: auto;" />

### Kaplan-Meier plot with number at risk table

<img src="man/figures/README-kmplot-1.png" width="100%" style="display: block; margin: auto;" />

### Model validation and calibration

<img src="man/figures/README-model-validation-calibration-1.png" width="100%" style="display: block; margin: auto;" />

### Model comparison by validation or calibration

<img src="man/figures/README-model-comparison-1.png" width="100%" style="display: block; margin: auto;" />

## Shiny app

- Shiny app: <https://github.com/nanxstats/hdnom-app>
- Shiny app maker: <https://github.com/nanxstats/hdnom-appmaker>

## Contribute

To contribute to this project, please take a look at the [Contributing
Guidelines](https://github.com/nanxstats/hdnom/blob/master/CONTRIBUTING.md)
first. Please note that this project is released with a [Contributor
Code of
Conduct](https://github.com/nanxstats/hdnom/blob/master/CONDUCT.md). By
participating in this project you agree to abide by its terms.
