% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harmonicHMC.R
\name{harmonicHMC}
\alias{harmonicHMC}
\title{Sample from a truncated Gaussian distribution with the harmonic HMC}
\usage{
harmonicHMC(
  n,
  burnin,
  mean,
  choleskyFactor,
  constraintDirec,
  constraintBound,
  init,
  integrationTime = c(pi/8, pi/2),
  precParametrized = TRUE,
  diagnosticMode = FALSE
)
}
\arguments{
\item{n}{number of samples after burn-in.}

\item{burnin}{number of burn-in samples.}

\item{mean}{a d-dimensional mean vector.}

\item{choleskyFactor}{upper triangular matrix R from Cholesky decomposition
of precision or covariance matrix into R^TR.}

\item{constraintDirec}{F matrix (k-by-d matrix where k is the number of
linear constraints).}

\item{constraintBound}{g vector (k-dimensional).}

\item{init}{a d-dimensional vector of the initial value. \code{init} must satisfy
all constraints.}

\item{integrationTime}{HMC integration time for each iteration. Can either be
a scalar value for a fixed time across all samples, or a length 2 vector of a
lower and upper bound for uniform distribution from which the time is drawn
from for each iteration.}

\item{precParametrized}{logical. whether \code{choleskyFactor} is from precision
(\code{TRUE}) or covariance matrix (\code{FALSE}).}

\item{diagnosticMode}{logical. \code{TRUE} for also returning the bounce distances
for each sample.}
}
\value{
List of
\code{samples}: (n + burnin) x d matrix of samples (including burnin samples) and
\code{bounceDistances}: list of bounces for each sample (only present if
\code{diagnosticMode} is \code{TRUE}).
}
\description{
Generate MCMC samples from a d-dimensional truncated Gaussian distribution
with constraints Fx+g >= 0 using the Harmonic Hamiltonian Monte Carlo sampler
(Harmonic-HMC).
}
\examples{
set.seed(1)
d <- 10
A <- matrix(runif(d^2)*2-1, ncol=d)
Sigma <- t(A) \%*\% A
R <- cholesky(Sigma)
mu <- rep(0,d)
constraintDirec <- diag(d)
constraintBound <- rep(0,d)
initial <- rep(1, d)
results <- harmonicHMC(
1000,
1000,
mu,
R,
constraintDirec,
constraintBound,
initial,
precParametrized = FALSE)
}
\references{
\insertRef{pakman2014exact}{hdtg}
}
