% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random-forest-development.R
\docType{class}
\name{RandomForestDevelopment}
\alias{RandomForestDevelopment}
\title{Compare predictive models, created on your data}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
RandomForestDevelopment(object, type, df, grainCol, predictedCol, 
impute, debug)
}
\arguments{
\item{object}{of SuperviseModelParameters class for $new() constructor}

\item{type}{The type of model (either 'regression' or 'classification')}

\item{df}{Dataframe whose columns are used for calc.}

\item{grainCol}{Optional. The dataframe's column that has IDs pertaining to 
the grain. No ID columns are truly needed for this step.}

\item{predictedCol}{Column that you want to predict. If you're doing
classification then this should be Y/N.}

\item{impute}{Set all-column imputation to F or T.
This uses mean replacement for numeric columns
and most frequent for factorized columns.
F leads to removal of rows containing NULLs.}

\item{debug}{Provides the user extended output to the console, in order
to monitor the calculations throughout. Use T or F.}
}
\description{
This step allows you to create a random forest model, based on
your data.
}
\examples{

#### Example using iris dataset ####
ptm <- proc.time()
library(healthcareai)

data(iris)
head(iris)

set.seed(42)

p <- SupervisedModelDevelopmentParams$new()
p$df <- iris
p$type <- "regression"
p$impute <- TRUE
p$grainCol <- ""
p$predictedCol <- "Sepal.Width"
p$debug <- FALSE
p$cores <- 1

# Run Lasso
lasso <- LassoDevelopment$new(p)
lasso$run()

set.seed(42)
# Run RandomForest
rf <- RandomForestDevelopment$new(p)
rf$run()

print(proc.time() - ptm)

#### Example using csv data ####
library(healthcareai)
# setwd('C:/Your/script/location') # Needed if using YOUR CSV file
ptm <- proc.time()

# Can delete this line in your work
csvfile <- system.file("extdata", 
                       "HCRDiabetesClinical.csv", 
                       package = "healthcareai")

# Replace csvfile with 'your/path'
df <- read.csv(file = csvfile, 
               header = TRUE, 
               na.strings = c("NULL", "NA", ""))

head(df)

df$PatientID <- NULL
df$InTestWindowFLG <- NULL

set.seed(42)

p <- SupervisedModelDevelopmentParams$new()
p$df <- df
p$type <- "regression"
p$impute <- TRUE
p$grainCol <- "PatientEncounterID"
p$predictedCol <- "A1CNBR"
p$debug <- FALSE
p$cores <- 1

# Run Lasso
lasso <- LassoDevelopment$new(p)
lasso$run()

set.seed(42) 
# Run Random Forest
rf <- RandomForestDevelopment$new(p)
rf$run()

print(proc.time() - ptm)

\donttest{
#### Example using SQL Server data ####

ptm <- proc.time()
library(healthcareai)

connection.string <- "
driver={SQL Server};
server=localhost;
database=SAM;
trusted_connection=true
"

query <- "
SELECT
[PatientEncounterID]
,[SystolicBPNBR]
,[LDLNBR]
,[A1CNBR]
,[GenderFLG]
,[ThirtyDayReadmitFLG]
,[InTestWindowFLG]
FROM [SAM].[dbo].[HCRDiabetesClinical]
WHERE InTestWindowFLG = 'N'
"

df <- selectData(connection.string, query)
head(df)

df$InTestWindowFLG <- NULL

set.seed(42)

p <- SupervisedModelDevelopmentParams$new()
p$df <- df
p$type <- "classification"
p$impute <- TRUE
p$grainCol <- "PatientEncounterID"
p$predictedCol <- "ThirtyDayReadmitFLG"
p$debug <- FALSE
p$cores <- 1

# Run Lasso
lasso <- LassoDevelopment$new(p)
lasso$run()

set.seed(42) 
# Run Random Forest
rf <- RandomForestDevelopment$new(p)
rf$run()

# Plot ROC
rocs <- list(rf$getROC(), lasso$getROC())
names <- c("Random Forest", "Lasso")
legendLoc <- "bottomright"
plotROCs(rocs, names, legendLoc)

# Plot PR Curve
rocs <- list(rf$getPRCurve(), lasso$getPRCurve())
names <- c("Random Forest", "Lasso")
legendLoc <- "bottomleft"
plotPRCurve(rocs, names, legendLoc)

print(proc.time() - ptm)
}

}
\references{
\url{http://hctools.org/}
}
\seealso{
\code{\link{LassoDevelopment}}

\code{\link{LinearMixedModelDevelopment}}

\code{\link{healthcareai}}
}
\keyword{datasets}
