% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hai-data-scale.R
\name{hai_data_scale}
\alias{hai_data_scale}
\title{Data Preprocessor - Scale/Normalize}
\usage{
hai_data_scale(
  .recipe_object = NULL,
  ...,
  .type_of_scale = "center",
  .range_min = 0,
  .range_max = 1,
  .scale_factor = 1
)
}
\arguments{
\item{.recipe_object}{The data that you want to process}

\item{...}{One or more selector functions to choose variables to be imputed.
When used with imp_vars, these dots indicate which variables are used to
predict the missing data in each variable. See selections() for more details}

\item{.type_of_scale}{This is a quoted argument and can be one of the following:
\itemize{
\item "center"
\item "normalize"
\item "range"
\item "scale"
}}

\item{.range_min}{A single numeric value for the smallest value in the range.
This defaults to 0.}

\item{.range_max}{A single numeric value for the largeest value in the range.
This defaults to 1.}

\item{.scale_factor}{A numeric value of either 1 or 2 that scales the numeric
inputs by one or two standard deviations. By dividing by two standard
deviations, the coefficients attached to continuous predictors can be
interpreted the same way as with binary inputs. Defaults to 1. More in reference below.}
}
\value{
A list object
}
\description{
Takes in a recipe and will scale values using a selected recipe. To call the
recipe use a quoted argument like "scale" or "normalize". This function
is not exported but may be called via the ::: method.
}
\details{
This function will get your data ready for processing with many types of ml/ai
models.

This is intended to be used inside of the data processor and
therefore is an internal function. This documentation exists to explain the process
and help the user understand the parameters that can be set in the pre-processor function.
}
\examples{
suppressPackageStartupMessages(library(dplyr))
suppressPackageStartupMessages(library(recipes))

date_seq <- seq.Date(from = as.Date("2013-01-01"), length.out = 100, by = "month")
val_seq <- rep(rnorm(10, mean = 6, sd = 2), times = 10)
df_tbl <- tibble(
  date_col = date_seq,
  value    = val_seq
)

rec_obj <- recipe(value ~ ., df_tbl)

healthyR.ai:::hai_data_scale(
  .recipe_object = rec_obj,
  value,
  .type_of_scale = "center"
)$scale_rec_obj \%>\%
  get_juiced_data()

}
\references{
Gelman, A. (2007) "Scaling regression inputs by
dividing by two standard deviations." Unpublished. Source:
\url{http://www.stat.columbia.edu/~gelman/research/unpublished/standardizing.pdf}.
}
\seealso{
\url{https://recipes.tidymodels.org/reference/index.html#section-step-functions-normalization}

step_center

\code{\link[recipes:step_center]{recipes::step_center()}}

\url{https://recipes.tidymodels.org/reference/step_center.html}

step_normalize

\code{\link[recipes:step_normalize]{recipes::step_normalize()}}

\url{https://recipes.tidymodels.org/reference/step_normalize.html}

step_range

\code{\link[recipes:step_range]{recipes::step_range()}}

\url{https://recipes.tidymodels.org/reference/step_range.html}

step_scale

\code{\link[recipes:step_scale]{recipes::step_scale()}}

\url{https://recipes.tidymodels.org/reference/step_scale.html}

Other Data Recipes: 
\code{\link{hai_data_impute}()},
\code{\link{hai_data_poly}()},
\code{\link{hai_data_transform}()},
\code{\link{hai_data_trig}()},
\code{\link{pca_your_recipe}()}

Other Preprocessor: 
\code{\link{hai_c50_data_prepper}()},
\code{\link{hai_cubist_data_prepper}()},
\code{\link{hai_data_impute}()},
\code{\link{hai_data_poly}()},
\code{\link{hai_data_transform}()},
\code{\link{hai_data_trig}()},
\code{\link{hai_earth_data_prepper}()},
\code{\link{hai_glmnet_data_prepper}()},
\code{\link{hai_knn_data_prepper}()},
\code{\link{hai_ranger_data_prepper}()},
\code{\link{hai_svm_poly_data_prepper}()},
\code{\link{hai_svm_rbf_data_prepper}()},
\code{\link{hai_xgboost_data_prepper}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Data Recipes}
\concept{Preprocessor}
