% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts-brownian-motion-augment.R
\name{ts_brownian_motion_augment}
\alias{ts_brownian_motion_augment}
\title{Brownian Motion}
\usage{
ts_brownian_motion_augment(
  .data,
  .date_col,
  .value_col,
  .time = 100,
  .num_sims = 10,
  .delta_time = NULL
)
}
\arguments{
\item{.data}{The data.frame/tibble being augmented.}

\item{.date_col}{The column that holds the date.}

\item{.value_col}{The value that is going to get augmented. The last value of
this column becomes the initial value internally.}

\item{.time}{How many time steps ahead.}

\item{.num_sims}{How many simulations should be run.}

\item{.delta_time}{Time step size.}
}
\value{
A tibble/matrix
}
\description{
Create a Brownian Motion Tibble
}
\details{
Brownian Motion, also known as the Wiener process, is a
continuous-time random process that describes the random movement of particles
suspended in a fluid. It is named after the physicist Robert Brown,
who first described the phenomenon in 1827.

The equation for Brownian Motion can be represented as:

\if{html}{\out{<div class="sourceCode">}}\preformatted{W(t) = W(0) + sqrt(t) * Z
}\if{html}{\out{</div>}}

Where W(t) is the Brownian motion at time t, W(0) is the initial value of the
Brownian motion, sqrt(t) is the square root of time, and Z is a standard
normal random variable.

Brownian Motion has numerous applications, including modeling stock prices in
financial markets, modeling particle movement in fluids, and modeling random
walk processes in general. It is a useful tool in probability theory and
statistical analysis.
}
\examples{
rn <- rnorm(31)
df <- data.frame(
 date_col = seq.Date(from = as.Date("2022-01-01"),
                      to = as.Date("2022-01-31"),
                      by = "day"),
 value = rn
)

ts_brownian_motion_augment(
  .data = df,
  .date_col = date_col,
  .value_col = value
)

}
\seealso{
Other Data Generator: 
\code{\link{tidy_fft}()},
\code{\link{ts_brownian_motion}()},
\code{\link{ts_geometric_brownian_motion_augment}()},
\code{\link{ts_geometric_brownian_motion}()},
\code{\link{ts_random_walk}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Data Generator}
