% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R, R/model_define.R
\name{define_model}
\alias{define_model}
\alias{define_model_}
\alias{define_strategy}
\alias{define_strategy_}
\title{Define a Markov Model}
\usage{
define_model(...)

define_model_(...)

define_strategy(..., transition = define_transition(),
  transition_matrix = NULL)

define_strategy_(transition, states)
}
\arguments{
\item{...}{Object generated by
\code{\link{define_state}}.}

\item{transition}{An object generated by
\code{\link{define_transition}}.}

\item{transition_matrix}{Deprecated argument, use
\code{transition}.}

\item{states}{List of states, only used by
\code{define_strategy_} to avoid using \code{...}.}
}
\value{
An object of class \code{uneval_model} (a list
  containing the unevaluated parameters, matrix and
  states).
}
\description{
Combine information on parameters, transition matrix and
states defined through \code{\link{define_parameters}},
\code{\link{define_transition}} and 
\code{\link{define_state}} respectively.
}
\details{
This function checks whether the objects are compatible
in the same model (same state names...).

State values and transition probabilities referencing
\code{state_cycle} are automatically expanded to implicit
tunnel states.
}
\examples{
mat <- define_transition(
  state_names = c("s1", "s2"),
  1 / c, 1 - 1/ c,
  0, 1
)

s1 <- define_state(
  cost = 234,
  utility = 1
  )
s2 <- define_state(
  cost = 421,
  utility = .5
  )

define_strategy(
  transition = mat,
  s1 = s1,
  s2 = s2
)
}

