% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_define.R
\name{define_surv_spline}
\alias{define_surv_spline}
\title{Define a Restricted Cubic Spline Survival Distribution}
\usage{
define_surv_spline(scale = c("hazard", "odds", "normal"), ...)
}
\arguments{
\item{scale}{"hazard", "odds", or "normal", as described
in flexsurvspline. With the default of no knots in
addition to the boundaries, these models reduce to the
Weibull, log-logistic and log-normal respectively. The
scale must be common to all times.}

\item{...}{Additional distribution parameters (see
respective distribution help pages).}
}
\value{
A \code{surv_dist} object.
}
\description{
Define a restricted cubic spline parametric survival
distribution.
}
\examples{

define_surv_spline(
  scale = "hazard", 
  gamma = c(-18.3122, 2.7511, 0.2292), 
  knots=c(4.276666, 6.470800, 7.806289)
)
define_surv_spline(
  scale = "odds", 
  gamma = c(-18.5809, 2.7973, 0.2035), 
  knots=c(4.276666, 6.470800, 7.806289)
)

}
