% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distancePlot.R
\name{distancePlot}
\alias{distancePlot}
\alias{distancePlot.default}
\alias{distancePlot.formula}
\alias{distancePlot.mlm}
\title{Distance Plot for Multivariate Model Diagnosis}
\usage{
distancePlot(X, Y, ...)

\method{distancePlot}{default}(
  X,
  Y,
  method = c("classical", "mcd", "mve"),
  level = 0.975,
  ids = rownames(X),
  pch = c(1, 16),
  col = c("black", "red"),
  label.pos = 2,
  xlab,
  ylab,
  verbose = FALSE,
  ...
)

\method{distancePlot}{formula}(X, Y, data, ...)

\method{distancePlot}{mlm}(X, ...)
}
\arguments{
\item{X}{A multivariate linear model fit by \code{\link[stats]{lm}}, or a numeric data frame giving the predictors in the MLM}

\item{Y}{A numeric data frame giving the responses in the MLM or the residuals}

\item{...}{Other arguments passed to methods}

\item{method}{Estimation method used for center and covariance, one of: \code{"classical"} (product-moment), 
\code{"mcd"} (minimum covariance determinant), or \code{"mve"} (minimum volume ellipsoid).}

\item{level}{Lower-tail probability beyond which observations will be labeled.}

\item{ids}{Labels for observations}

\item{pch}{A vector of two point symbols, for the regular points and those beyond the cutoffs}

\item{col}{A vector of two colors, for the regular points and those beyond the cutoffs}

\item{label.pos}{Position of the label relative to the point; see \code{\link[graphics]{text}}}

\item{xlab}{Label stub for horizontal axis}

\item{ylab}{Label stub for vertical axis}

\item{verbose}{Logical; if \code{TRUE} print the cutoff values to the console}

\item{data}{For the formula method, the dataset containing the variables}
}
\value{
Returns invisibly a data frame containing the distances, \code{distX}, \code{distY}
}
\description{
This plot, suggested by Rousseeuw & van Zomeren (1991), Rousseeu et al. (2004) typically plots Mahalanobis distances (\eqn{D}) of the \code{Y} response
variables against the distances of the \code{X} variables in a multivariate linear model (MLM).
When applied to a multivariate linear model itself, it plots the distances of the \emph{residuals} for the \code{Y} variables
against the predictor terms in the \emph{model.matrix} \code{X}.

This diagnostic plot combines the information on regression outliers and leverage points, and often more useful than either distance separately.
}
\details{
Observations with "large" distances on \code{X} or \code{Y} are labeled with their \code{ids}. The cutoffs are calculated as 
\eqn{\sqrt{\chi^2_{k, \text{level}}}}.
}
\examples{

if(require("robustbase")) {
  # Examples from Rousseeuw etal (2004)
  data(pulpfiber, package="robustbase")
  # Figure 1
  distancePlot(pulpfiber[, 1:4], pulpfiber[, 5:8])   
  # Figure 3
  pulp.mod <- lm(cbind(Y1, Y2, Y3, Y4) ~ X1 + X2 + X3 + X4, data = pulpfiber)
  distancePlot(pulp.mod, method = "mcd")
}

# NLSY data
data(NLSY, package = "heplots")
NLSY.mlm <- lm(cbind(math, read) ~ income + educ + antisoc + hyperact,
               data = NLSY)

distancePlot(NLSY.mlm)

# gives the same result
distancePlot(NLSY[, 3:6], residuals(NLSY.mlm), level = 0.975)

distancePlot(NLSY.mlm, method ="mve")

# distancePlot(cbind(math, read) ~ income + educ + antisoc + hyperact,
#                data = NLSY)

# schooldata dataset
data(schooldata)
school.mod <- lm(cbind(reading, mathematics, selfesteem) ~ ., data=schooldata)
distancePlot(school.mod)

data(Hernior)
Hern.mod <- lm(cbind(leave, nurse, los) ~
               age + sex +  pstat +  build + cardiac + resp, data=Hernior)
distancePlot(Hern.mod)

}
\references{
Rousseeuw P. J. & van Zomeren B. C. (1991). “Robust Distances: Simulation and Cutoff Values.”
In W Stahel, S Weisberg (eds.), \emph{Directions in Robust Statistics and Diagnostics, Part II}.
Springer-Verlag, New York.

Rousseeuw, P. J., Van Driessen, K., Van Aelst, S., & Agullo, J. (2004). Robust multivariate regression. 
\emph{Technometrics}, \bold{46}(3), 293–305. \doi{10.1198/004017004000000329}.
}
\seealso{
\code{\link{Mahalanobis}}
}
