
\name{hergm.postprocess}

\alias{hergm.postprocess}

\alias{postprocess}

\title{Postprocess output returned by function hergm}

\description{

The function \code{hergm.postprocess} postprocesses the output returned by the function \code{hergm}.
If \code{hergm.postprocess} is called with \code{relabel > 0},
it solves the so-called label-switching problem.
The label-switching problem is rooted in the invariance of the likelihood function to permutations of the labels of blocks, and implies that raw MCMC samples from the posterior cannot be used to infer to block-dependent entities.
The label-switching problem can be solved in a Bayesian decision-theoretic framework: by choosing a loss function and minimizing the posterior expected loss.
Two loss functions are implemented in \code{hergm.postprocess}, the loss function of Schweinberger and Handcock (2015) (\code{relabel == 1}) and the loss function of Peng and Carvalho (2015) (\code{relabel == 2}).
The first loss function seems to be superior in terms of the reported clustering probabilities, but is more expensive in terms of computing time.
A rule of thumb is to use the first loss function when \code{max_number < 15} and use the second loss function otherwise.

}

\usage{

hergm.postprocess(sample = NULL,
                  seed = NULL,
                  burnin = 0, 
                  thinning = 1,
                  relabel = 0,
                  number_runs = 1,
                  extract = NULL,
                  \dots)

}

\arguments{

\item{sample}{MCMC sample generated by function \code{hergm}.}

\item{seed}{seed of pseudo-random number generator.}

\item{burnin}{number of burn-in iterations; if computing is parallel, number of burn-in iterations per processor.}

\item{thinning}{if \code{thinning > 1}, every \code{thinning}-th sample point is used while all others discarded.}

\item{relabel}{if \code{relabel > 0}, relabel MCMC sample by minimizing the posterior expected loss of Schweinberger and Handcock (2015) (\code{relabel == 1}) or Peng and Carvalho (2015) (\code{relabel == 2}).}

\item{number_runs}{if \code{relabel == 1}, number of runs of relabeling algorithm.}

\item{extract}{if \code{extract == TRUE}, the MCMC is extracted from \code{sample}.}

\item{\dots}{additional arguments, to be passed to lower-level functions in the future.}

}

\value{

\item{ergm_theta}{parameters of \code{ergm-terms}.}

\item{alpha}{concentration parameter of truncated Dirichlet process prior of parameters of \code{hergm-terms}.} 

\item{eta_mean}{mean parameters of Gaussian base distribution of parameters of \code{hergm-terms}.}

\item{eta_precision}{precision parameters of Gaussian base distribution of parameters of \code{hergm-terms}.}

\item{hergm_theta}{parameters of \code{hergm-terms}.}

\item{loss}{if \code{relabel == TRUE}, local minimum of loss function.}

\item{p_k}{probabilities of membership to blocks.}

\item{indicator}{indicators of memberships of nodes.}

\item{p_i_k}{probabilities of membership of nodes to blocks.}

\item{prediction}{posterior predictions of statistics.}

}

\seealso{hergm, hergm.gof, hergm.plot}

\references{

Peng, L. and L. Carvalho (2015). Bayesian degree-corrected stochastic block models for community detection. Technical report, Boston University, arXiv:1309.4796v1.

Schweinberger, M. and M. S. Handcock (2015). Local dependence in random graph models: characterization, properties, and statistical Inference. Journal of the Royal Statistical Society, Series B (Statistical Methodology), 7, 1-30, in press.

}

\examples{
\dontrun{
data(example)

sample <- hergm(d ~ edges_ij + triangle_ijk)

processed.sample <- hergm.postprocess(sample)
}
}

