% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_mats.R
\name{create_input_mats}
\alias{create_input_mats}
\alias{create_input_mats.formula_list}
\alias{create_input_mats.lm}
\alias{create_input_mats.lm_list}
\alias{create_input_mats.flexsurvreg}
\alias{create_input_mats.flexsurvreg_list}
\alias{create_input_mats.partsurvfit}
\alias{create_input_mats.params_lm}
\alias{create_input_mats.params_surv}
\alias{create_input_mats.params_surv_list}
\alias{create_input_mats.multinom}
\alias{create_input_mats.multinom_list}
\title{Create input matrices}
\usage{
create_input_mats(object, ...)

\method{create_input_mats}{formula_list}(object, input_data, ...)

\method{create_input_mats}{lm}(object, input_data, ...)

\method{create_input_mats}{lm_list}(object, input_data, ...)

\method{create_input_mats}{flexsurvreg}(object, input_data, ...)

\method{create_input_mats}{flexsurvreg_list}(object, input_data, ...)

\method{create_input_mats}{partsurvfit}(object, input_data, ...)

\method{create_input_mats}{params_lm}(object, input_data, ...)

\method{create_input_mats}{params_surv}(object, input_data, ...)

\method{create_input_mats}{params_surv_list}(object, input_data, ...)

\method{create_input_mats}{multinom}(object, input_data, ...)

\method{create_input_mats}{multinom_list}(object, input_data, ...)
}
\arguments{
\item{object}{An object of the appropriate class.}

\item{...}{Further arguments passed to \code{\link{model.matrix}}.}

\item{input_data}{An object of class "expanded_hesim_data" returned by the function
\code{\link{expand.hesim_data}}. Used to look for the input variables needed to create an input matrix
for use in a statistical models and the id variables for indexing rows in the input matrix.}
}
\value{
An object of class \code{\link{input_mats}}.
}
\description{
\code{create_input_mats} is a generic function for creating an object of class
\code{\link{input_mats}}. Model matrices are typically constructed based on the
variables specified in the model \code{object} and the data specified in \code{data},
although there are some cases in which \code{\link{input_mats}} can be created
from \code{object} alone.
}
\examples{
library("flexsurv")

dt_strategies <- data.frame(strategy_id = c(1, 2))
dt_patients <- data.frame(patient_id = seq(1, 3), 
                          age = c(45, 47, 60),
                          female = c(1, 0, 0),
                          group = factor(c("Good", "Medium", "Poor")))
dt_states <- data.frame(state_id =  seq(1, 3),
                        state_name = factor(paste0("state", seq(1, 3))))
hesim_dat <- hesim_data(strategies = dt_strategies,
                        patients = dt_patients,
                        states = dt_states)

# Class "lm"
expanded_dat <- expand(hesim_dat, by = c("strategies", "patients", "states"))
fit_lm <- stats::lm(costs ~ female + state_name, psm4_exdata$costs$medical)
input_mats <- create_input_mats(fit_lm, expanded_dat)
class(input_mats)

# Class "flexsurvreg"
expanded_dat <- expand(hesim_dat, by = c("strategies", "patients"))
fit_wei <- flexsurv::flexsurvreg(formula = Surv(futime, fustat) ~ 1, 
                                 data = ovarian, dist = "weibull")
input_mats <- create_input_mats(fit_wei, expanded_dat)
class(input_mats)
}
\seealso{
\code{\link{input_mats}}.
}
\keyword{internal}
