% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpmatrix.R
\name{tpmatrix_names}
\alias{tpmatrix_names}
\title{Names for elements of a transition probability matrix}
\usage{
tpmatrix_names(states, prefix = "p_", sep = "_")
}
\arguments{
\item{states}{A character vector of the names of health states in the
transition matrix.}

\item{prefix}{A prefix that precedes the described transitions between states.}

\item{sep}{A character string to separate the terms representing
state \code{i} and state \code{j}.}
}
\value{
A character vector containing a name for each element of the transition
probability matrix encompassing all possible transitions.
}
\description{
Create names for all elements of a transition probability matrix given
names for the health states. This is useful for flattening a transition
probability matrix (rowwise) into a vector and naming the resulting vector.
The name of an element of the flattened vector representing a transition from
the ith state to the jth state is of the form
\code{paste0(prefix, state_i, sep, state_j)}.
}
\examples{
tpmatrix_names(LETTERS[1:4])
tpmatrix_names(LETTERS[1:4], prefix = "")
tpmatrix_names(LETTERS[1:4], prefix = "", sep = ".")

}
