% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctstm.R
\name{create_IndivCtstmTrans}
\alias{create_IndivCtstmTrans}
\alias{create_IndivCtstmTrans.flexsurvreg_list}
\alias{create_IndivCtstmTrans.flexsurvreg}
\alias{create_IndivCtstmTrans.params_surv}
\alias{create_IndivCtstmTrans.params_surv_list}
\title{Create \code{IndivCtstmTrans} object}
\usage{
create_IndivCtstmTrans(object, ...)

\method{create_IndivCtstmTrans}{flexsurvreg_list}(
  object,
  input_data,
  trans_mat,
  clock = c("reset", "forward"),
  n = 1000,
  uncertainty = c("normal", "none"),
  ...
)

\method{create_IndivCtstmTrans}{flexsurvreg}(
  object,
  input_data,
  trans_mat,
  clock = c("reset", "forward"),
  n = 1000,
  uncertainty = c("normal", "none"),
  ...
)

\method{create_IndivCtstmTrans}{params_surv}(
  object,
  input_data,
  trans_mat,
  clock = c("reset", "forward", "mix"),
  reset_states = NULL,
  ...
)

\method{create_IndivCtstmTrans}{params_surv_list}(
  object,
  input_data,
  trans_mat,
  clock = c("reset", "forward", "mix"),
  reset_states = NULL,
  ...
)
}
\arguments{
\item{object}{A fitted survival model or the parameters of a survival model.}

\item{...}{Further arguments passed to \code{IndivCtstmTrans$new()} in \code{\link{IndivCtstmTrans}}.}

\item{input_data}{An object of class \code{expanded_hesim_data} returned by
\code{\link{expand.hesim_data}}.}

\item{trans_mat}{The transition matrix describing the states and transitions in a
multi-state model in the format from the \code{\link[mstate:mstate]{mstate}} package. See \code{\link{IndivCtstmTrans}}.}

\item{clock}{"reset" for a clock-reset model, "forward" for a clock-forward model, and "mix" for a mixture
of clock-reset and clock-forward models. See the field \code{clock} in \code{\link{IndivCtstmTrans}}.}

\item{n}{Number of random observations of the parameters to draw.}

\item{uncertainty}{Method determining how parameter uncertainty should be handled. See
documentation in \code{\link[=create_params]{create_params()}}.}

\item{reset_states}{A vector denoting the states in which time resets. See the field
\code{reset_states} in \code{\link{IndivCtstmTrans}}.}
}
\value{
Returns an \code{\link{R6Class}} object of class \code{\link{IndivCtstmTrans}}.
}
\description{
A generic function for creating an object of class \code{\link{IndivCtstmTrans}}.
}
\seealso{
\code{\link{IndivCtstmTrans}}
}
