% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pin_ctrl.R
\name{pin_ctrl}
\alias{pin_ctrl}
\alias{hetu_ctrl}
\title{Check Validity of Personal Identity Code}
\usage{
pin_ctrl(pin, allow.temp = FALSE)

hetu_ctrl(pin, allow.temp = FALSE)
}
\arguments{
\item{pin}{Finnish personal identity code(s) as a character vector}

\item{allow.temp}{If TRUE, temporary PINs (personal numbers 900-999) are
handled similarly to regular PINs (personal numbers 002-899), meaning
that otherwise valid temporary PIN will return a TRUE. Default
is \code{FALSE}.}
}
\value{
A logical vector indicating whether the input vector contains valid
 Finnish personal identity codes.
}
\description{
Validate Finnish personal identity codes (hetu).
}
\examples{
pin_ctrl("010101-0101") # TRUE
pin_ctrl("010101-010A") # FALSE
pin_ctrl(c("010101-0101", "010101-010A")) # TRUE FALSE
hetu_ctrl("010101-0101") # TRUE
hetu_ctrl("010101-010A") # FALSE
hetu_ctrl(c("010101-0101", "010101-010A")) # TRUE FALSE
}
\seealso{
\code{\link{hetu}} For extracting information from Finnish personal
   identity codes.
}
\author{
Pyry Kantanen
}
