% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row_pair_apply.R
\name{heuristicsList}
\alias{heuristicsList}
\title{Wrapper for fitted heuristics to generate predictions with rowPairApply.}
\usage{
heuristicsList(list_of_fitted_heuristics, fn)
}
\arguments{
\item{list_of_fitted_heuristics}{Normally a list of predictProbInternal
implementers, e.g. a fitted ttb model.}

\item{fn}{The function to be called on the heuristics, which is typically
predictPairInternal (or the experimental function predictProbInternal)
but can be any function with the signature function(object, row1, row2)
that is implemented by the heuristics in list_of_fitted_heuristics.}
}
\value{
An object of class heuristics, which implements createFunction.
  Users will generally not use this directly-- rowPairApply will.
}
\description{
A list of fitted heuristics are passed in.  They must all implement
the fn function passed in, and they must all have the same cols_to_fit.
If they differ on these, then group them in separate heuristicsLists.
}
\details{
Users will generally not use the output directly-- instead just pass this
into one of the rowPairApply functions.
}
\examples{
# Use one fitted ttbModel with column 1 as criterion and columns 2,3 as
# cues.
data <- cbind(y=c(30,20,10,5), x1=c(1,1,0,0), x2=c(1,1,0,1))
ttb <- ttbModel(data, 1, c(2:3))
rowPairApply(data, heuristicsList(list(ttb), predictPairInternal))
# This outputs ttb's predictions for all 6 row pairs of data.
# (It has 6 row pairs because 4*2/2 = 6.)  It gets the predictions
# by calling ttb's predictPairInternal.

# Use the same fitted ttbModel plus a unit weight model with the same
# criterion and cues.
unit <- unitWeightModel(data, 1, c(2,3))
rowPairApply(data, heuristicsList(list(ttb, unit), predictPairInternal))
# This outputs predictions with column names 'ttbModel' and
# 'unitWeightLinearModel'.

# Use the same fitted ttbModel plus another ttbModel that has different
# cols_to_fit.  This has to be put in a separate heuristicsList function.
ttb_just_col_3 <- ttbModel(data, 1, c(3), fit_name="ttb3")
rowPairApply(data, heuristicsList(list(ttb), predictPairInternal),
  heuristicsList(list(ttb_just_col_3), predictPairInternal))
# This outputs predictions with column names 'ttbModel' and
# 'ttb3'.

}
\seealso{
\code{\link{rowPairApply}} which is what the output of heuristicsList is
normally passed in to.

\code{\link{heuristics}} for a simpler version of this function with more
examples.  It is recommended for most uses.  (It is hard-coded for
fn=predictPairInternal, which is what most people use.)

\code{\link{heuristicsProb}} for a version of this function tailored for
predictProbInternal rather than predictPairInternal.
}
