% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mstep-mix-mvnorm.R
\name{mixmvnorm_mstep}
\alias{mixmvnorm_mstep}
\title{the M step function of the EM algorithm}
\usage{
mixmvnorm_mstep(x, wt1, wt2)
}
\arguments{
\item{x}{the observation matrix}

\item{wt1}{the state probabilities matrix (number of observations
times number of states)}

\item{wt2}{the mixture components probabilities list (of length
nstate) of matrices (number of observations times number of
mixture components)}
}
\value{
list of emission (mixture multivariate normal) parameters:
(\code{mu}, \code{sigma} and \code{mix.p})
}
\description{
The M step function of the EM algorithm for the mixture
of multivariate normals as the emission distribution using the
observation matrix and the estimated weight vectors
}
\examples{
data(CMAPSS)
n = nrow(CMAPSS$train$x)
wt1 = matrix(runif(3*n),nrow=n,ncol=3)
wt2 = list()
for(j in 1:3) wt2[[j]] = matrix(runif(5*n),nrow=n,ncol=5)
emission = mixmvnorm_mstep(CMAPSS$train$x, wt1, wt2)

}
\author{
Morteza Amini, \email{morteza.amini@ut.ac.ir}, Afarin Bayat,  \email{aftbayat@gmail.com}
}
