\name{hh_render}
\alias{hh_render}
\title{Render Hilbert spectrogram}
\description{
This function prepares results from the Hilbert transform of EMD or EEMD results for display using \code{\link{hhspec_image}}.
}
\usage{
hh_render(hres, max_freq, freq_step, imf_list=NULL)  
}
\arguments{
\item{hres}{This is the output generated by \code{\link{eemd_compile}}, \code{\link{eemd_resift}}, or \code{\link{hhtransform}}.}
\item{max_freq}{Maximum frequency to plot on spectrogram.}
\item{freq_step}{Frequency resolution.}
\item{imf_list}{IMFs to include in spectrogram}
}
\details{
\code{hh_render} processes Hilbert spectral data prior to display.
This function is separate from the plotting function \code{\link{hhspec_image}} because it is computer intensive to generate the spectral data.
It is best to generate the spectrogram first, then change the options in \code{\link{hhspec_image}} to display the image you want, rather than recalculating the spectrogram every time.
}

\note{The \code{hh_render} function also keeps track of which trial contributes what data to the spectrogram.
For the EMD, this does not make much sense, because there is only one trial.
However, when \code{hh_render} is run on EEMD results, it remembers which time/frequency bin gets data from each trial.
This is a way to distinguish between noise and signal in data:  signal is where multiple trials contribute data to the same time/frequency bin,
noise is where only one (or a couple) of trials contribute data.
The \code{cluster_span} option in \code{\link{hhspec_image}} function allows users to restrict the spectrogram display to only those pixels that have multiple trial hits in them.}

\value{ 
\item{hspec}{A data structure containing the spectrogram image and other information required by \code{\link{hhspec_image}}.}
}

\author{Daniel Bowman \email{daniel.bowman@unc.edu}}

\seealso{
\code{\link{eemd_compile}}, \code{\link{hhspec_image}}
}
\examples{
data(port_foster_event)

emd_config=list()
emd_config$max_sift=200
emd_config$max_imf=100
emd_config$tol=0.2
emd_config$stop_rule="type5"
emd_config$boundary="wave"
emd_config$sm="none"
emd_config$spar=NA
emd_config$weight=20
emd_config$S=5

trials=10
nimf=10
noise_amp=6.4e-07
trials_dir="test"

set.seed(628)
#Run EEMD (this may take some time)
\dontrun{eemd(sig, dt, trials, nimf, noise_amp, emd_config, trials_dir)}

#Compile the results
\dontrun{eemd_result=eemd_compile(trials_dir, trials, nimf)}

#Calculate spectrogram
max_freq=25
freq_step=0.01
\dontrun{hspec=hh_render(eemd_result, max_freq, freq_step)}

#Plot spectrogram 
time_span=c(5, 10)
freq_span=c(0, 25)
amp_span=c(1e-6, 2.5e-5)
\dontrun{hhspec_image(hspec, time_span, freq_span, amp_span)}
}
\keyword{nonparametric}
