% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_handling.R
\name{businessTimeAggregation}
\alias{businessTimeAggregation}
\title{Business time aggregation}
\usage{
businessTimeAggregation(
  pData,
  measure = "volume",
  obs = 390,
  bandwidth = 0.075,
  ...
)
}
\arguments{
\item{pData}{xts or data.table containing data to aggregate.}

\item{measure}{character denoting which measure to use. Valid options are "intensity", "vol", and "volume", denoting the trade intensity process of Oomen (2005),
volatility, and volume, respectively. Default is "volume"}

\item{obs}{integer valued numeric of length 1 denoting how many observations is wanted after the aggregation procedure.}

\item{bandwidth}{numeric of length one, denoting which bandwidth parameter to use in the trade intensity process estimation of Oomen (2005.)}

\item{...}{extra arguments passed on to \code{\link{spotVol}} when measure is "vol"}
}
\value{
A list containing "pData" which is the aggregated data and a list containing the intensity process, split up day by day.
}
\description{
Time series aggregation based on `business time` statistics. Instead of equidistant sampling based on time during a trading day, business time sampling creates measures and samples equidistantly using these instead.
For example when sampling based on volume, business time aggregation will result in a time series that has an equal amount of volume between each observation (if possible).
}
\examples{
pData <- sampleTData[,c("PRICE", "SIZE")]
storage.mode(pData) <- "numeric"
# Aggregate based on the trade intensity measure. Getting 390 observations.
agged <- businessTimeAggregation(pData, measure = "intensity", obs = 390, bandwidth = 0.075)
# Plot the trade intensity measure
plot.ts(agged$intensityProcess$`2008-01-04`)
rCov(agged$pData[,"PRICE"], makeReturns = TRUE)
rCov(pData[,"PRICE"], makeReturns = TRUE, alignBy = "minutes", alignPeriod = 1)

# Aggregate based on the volume measure. Getting 78 observations.
agged <- businessTimeAggregation(pData, measure = "volume", obs = 78)
rCov(agged$pData[,"PRICE"], makeReturns = TRUE)
rCov(pData[,"PRICE"], makeReturns = TRUE, alignBy = "minutes", alignPeriod = 5)

}
\references{
Roel C. A. Oomen Properties of realized variance under alternative sampling schemes. (2006) Journal of Business & Economic Statistics 24, pages 219-237

Yingjie Dong and Yiu Kuen Tse. (2017) Business time sampling scheme with applications to testing semi-martingale hypothesis and estimating integrated volatility. Econometrics, 5
}
\author{
Emil Sjoerup
}
