% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_handling.R
\name{quotesCleanup}
\alias{quotesCleanup}
\title{Cleans quote data}
\usage{
quotesCleanup(
  dataSource = NULL,
  dataDestination = NULL,
  exchanges,
  qDataRaw = NULL,
  report = TRUE,
  selection = "median",
  maxi = 50,
  window = 50,
  type = "advanced",
  rmoutliersmaxi = 10,
  saveAsXTS = TRUE,
  tz = "EST"
)
}
\arguments{
\item{dataSource}{character indicating the folder in which the original data is stored.}

\item{dataDestination}{character indicating the folder in which the cleaned data is stored.}

\item{exchanges}{vector of stock exchange symbols for all data in dataSource, 
e.g. exchanges = c("T","N") retrieves all stock market data from both NYSE and NASDAQ.
The possible exchange symbols are:
\itemize{
\item A: AMEX
\item N: NYSE
\item B: Boston
\item P: Arca
\item C: NSX
\item T/Q: NASDAQ
\item D: NASD ADF and TRF
\item X: Philadelphia
\item I: ISE
\item M: Chicago
\item W: CBOE
\item Z: BATS
}}

\item{qDataRaw}{xts or data.table object containing (ONE stock only) raw quote data. This argument is NULL by default. Enabling it means the arguments
from, to, dataSource and dataDestination will be ignored. (only advisable for small chunks of data)}

\item{report}{boolean and TRUE by default. In case it is true the function returns (also) a vector indicating how many quotes remained after each cleaning step.}

\item{selection}{argument to be passed on to the cleaning routine \code{\link{mergeQuotesSameTimestamp}}. The default is "median".}

\item{maxi}{spreads which are greater than median(spreads of day) times maxi are excluded.}

\item{window}{argument to be passed on to the cleaning routine \code{\link{rmOutliersQuotes}}.}

\item{type}{argument to be passed on to the cleaning routine \code{\link{rmOutliersQuotes}}.}

\item{rmoutliersmaxi}{argument to be passed on to the cleaning routine \code{\link{rmOutliersQuotes}}.}

\item{saveAsXTS}{indicates whether data should be saved in xts format instead of data.table when using on-disk functionality. TRUE by default.}

\item{tz}{timezone to use}
}
\value{
The function converts every csv file in dataSource into multiple xts or data.table files.
In dataDestination, there will be one folder for each symbol containing .rds files with cleaned data stored either in data.table or xts format.

In case you supply the argument "qDataRaw", the on-disk functionality is ignored
and the function returns a list with the cleaned quotes as an xts or data.table object depending on input (see examples).
}
\description{
This is a wrapper function for cleaning the quote data in the entire folder dataSource. 
The result is saved in the folder dataDestination. 

In case you supply the argument "qDataRaw", the on-disk functionality is ignored
and the function returns the cleaned quotes as xts or data.table object (see examples).

The following cleaning steps are performed sequentially:
\code{\link{noZeroQuotes}}, \code{\link{selectExchange}}, rmLargeSpread,
\code{\link{mergeQuotesSameTimestamp}}, \code{\link{rmOutliersQuotes}}.
}
\examples{
# Consider you have raw quote data for 1 stock for 2 days
head(sampleQDataRawMicroseconds)
dim(sampleQDataRawMicroseconds)
qDataAfterCleaning <- quotesCleanup(qDataRaw = sampleQDataRawMicroseconds, exchanges = "N")
qDataAfterCleaning$report
dim(qDataAfterCleaning$qData)

# In case you have more data it is advised to use the on-disk functionality
#via "dataSource" and "dataDestination" arguments

}
\references{
Barndorff-Nielsen, O. E., P. R. Hansen, A. Lunde, and N. Shephard (2009). Realized kernels in practice: Trades and quotes. Econometrics Journal 12, C1-C32.
Brownlees, C.T. and Gallo, G.M. (2006). Financial econometric analysis at ultra-high frequency: Data handling concerns. Computational Statistics & Data Analysis, 51, pages 2232-2245.
Falkenberry, T.N. (2002). High frequency data filtering. Unpublished technical report.
}
\author{
Jonathan Cornelissen, Kris Boudt and Onno Kleen.
}
\keyword{cleaning}
