% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataHandling.R
\name{autoSelectExchangeQuotes}
\alias{autoSelectExchangeQuotes}
\title{Retain only data from the stock exchange with the highest volume}
\usage{
autoSelectExchangeQuotes(qData, printExchange = TRUE)
}
\arguments{
\item{qData}{a \code{data.table} or \code{xts} object with at least a column \code{"EX"}, indicating the exchange symbol 
and columns \code{"BIDSIZ"} and \code{"OFRSIZ"}, indicating 
the volume available at the bid and ask respectively.}

\item{printExchange}{indicates whether the chosen exchange is printed on the console, default is \code{TRUE}.
The possible exchanges are:
\itemize{
\item A: AMEX
\item N: NYSE
\item B: Boston
\item P: Arca
\item C: NSX
\item T/Q: NASDAQ
\item D: NASD ADF and TRF
\item X: Philadelphia
\item I: ISE
\item M: Chicago
\item W: CBOE
\item Z: BATS
}}
}
\value{
\code{data.table} or \code{xts} object depending on input.
}
\description{
Filters raw quote data and return only data that stems from the exchange with the highest
value for the sum of \code{"BIDSIZ"} and \code{"OFRSIZ"}, i.e. the highest quote volume.
}
\examples{
autoSelectExchangeQuotes(sampleQDataRaw)

}
\author{
Jonathan Cornelissen, Kris Boudt, Onno Kleen, and Emil Sjoerup.
}
\keyword{cleaning}
