
#' The highriskzone-package provides tools to determine and evaluate high-risk zones of 
#' unobserved events using point process methodology. 
#'
#' \tabular{ll}{
#' Package: \tab highriskzone\cr
#' Type: \tab Package\cr
#' Version: \tab 1.0\cr
#' Date: \tab 2012-07-11\cr
#' License: \tab MIT\cr
#' LazyLoad: \tab yes\cr
#' }
#'
#' @author
#' Heidi Seibold \email{Heidi.Seibold@@campus.lmu.de},
#' Monia Mahling \email{monia.mahling@@stat.uni-muenchen.de}
#' 
#'
#' Maintainer: Heidi Seibold \email{Heidi.Seibold@@campus.lmu.de}
#' @name highriskzone-package
#' @docType package
#' @aliases highriskzone package-highriskzone
#' @import spatstat ks
#' @title Determining high risk zones using point process methodology
#' @keywords package
#' @references Monia Mahling, Michael \enc{Hhle}{Hoehle}& Helmut \enc{Kchenhoff}{Kuechenhoff} (expected 2013), 
#' \emph{Determining high-risk zones for unexploded World War II bombs by using point process methodology.}
#' in Journal of the Royal Statistical Society, Series C. 
#' \url{http://onlinelibrary.wiley.com/doi/10.1111/j.1467-9876.2012.01055.x/abstract} \cr
#' 
#' Heidi Seibold (2012), \emph{Determining high risk zones using point process methodology 
#' - Realization by building an R package.} Bachelor Thesis, Ludwig Maximilian University of Munich.
#' @seealso  \code{\link[spatstat]{spatstat-package}}
#' @encoding latin1
#' 
NULL