% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readh_freqs.R
\name{hipread_freqs}
\alias{hipread_freqs}
\title{Calculate frequencies from fixed width file without loading into memory}
\usage{
hipread_freqs(file, var_info, rt_info = hip_rt(1, 0),
  compression = NULL, progress = show_progress())
}
\arguments{
\item{file}{A filename}

\item{var_info}{Variable information, specified by either \code{\link[=hip_fwf_positions]{hip_fwf_positions()}}
or \code{hip_fwf_widths()}. For hierarchical data files, there should be a named list,
where the name is the value indicated by the record type variable and there is
one variable information per record type.}

\item{rt_info}{A record type information object, created by \code{\link[=hip_rt]{hip_rt()}}, which
contains information about the location of the record type variable that
defines the record type for each observation. The default contains width
0, which indicates that there the data is rectangular and does not have
a record type variable.}

\item{compression}{If \code{NULL}, guesses the compression from the
file extension (if extension is "gz" uses gzip, otherwise
treats as plain text), can specify it with a string ("txt"
indicates plain text and "gz" for gzip).}

\item{progress}{A logical indicating whether progress should be
displayed on the screen, defaults to showing progress unless
the current context is non-interactive or in a knitr document or
if the user has turned off readr's progress by default using
the option \code{options("readr.show_progress")}.}
}
\value{
A list of frequencies
}
\description{
Calculate the frequency of values in all variables in a fixed width file.
Does so without holding the whole data in memory or creating a full
R data.frame and calling R code on interim pieces. (Probably only
useful inside IPUMS HQ).
}
\keyword{internal}
