% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_lattice}
\alias{plot_lattice}
\title{Plot Lattice of Emulator Implausibilities}
\usage{
plot_lattice(ems, targets, ppd = 20, cb = FALSE, cutoff = 3, maxpoints = 50000)
}
\arguments{
\item{ems}{The \code{\link{Emulator}} objects in question.}

\item{targets}{The corresponding target values.}

\item{ppd}{The number of points to sample per dimension.}

\item{cb}{Whether or not a colourblind-friendly plot should be produced.}

\item{cutoff}{The cutoff value for non-implausible points.}

\item{maxpoints}{The limit on the number of points to be evaluated.}
}
\value{
A ggplot object
}
\description{
Plots a set of projections of the full-dimensional input space.
}
\details{
The plots are:

One dimensional optical depth plots (diagonal);

Two dimensional optical depth plots (lower triangle);

Two dimensional minimum implausibility plots (upper triangle).

The optical depth is calculated as follows. A set of points is constructed across the
full d-dimensional parameter space, and implausibility is calculated at each point.
The points are collected into groups based on their placement in a projection to a
one- or two-dimensional slice of the parameter space. For each group, the proportion
of non-implausible points is calculated, and this value in [0,1] is plotted. The
minimum implausibility plots are similar, but with minimum implausibility calculated
rather than proportion of non-implausible points.

The \code{maxpoints} argument is used as a cutoff for if a regular ppd grid would
result in a very large number of points. If this is the case, then \code{maxpoints} points
are sampled uniformly from the region instead of regularly spacing them.
}
\examples{
\donttest{
 plot_lattice(SIREmulators$ems, SIREmulators$targets, ppd = 10)
 plot_lattice(SIREmulators$ems$nS, SIREmulators$targets)
}
}
\references{
Bower, Goldstein & Vernon (2010) <doi:10.1214/10-BA524>
}
\seealso{
Other visualisation tools: 
\code{\link{behaviour_plot}()},
\code{\link{diagnostic_wrap}()},
\code{\link{effect_strength}()},
\code{\link{emulator_plot}()},
\code{\link{output_plot}()},
\code{\link{plot_actives}()},
\code{\link{plot_wrap}()},
\code{\link{simulator_plot}()},
\code{\link{space_removed}()},
\code{\link{validation_pairs}()},
\code{\link{wave_dependencies}()},
\code{\link{wave_points}()},
\code{\link{wave_values}()}
}
\concept{visualisation tools}
