% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmi_imp_cat_multi_2017-04-11.R
\name{imp_cat_multi}
\alias{imp_cat_multi}
\title{The function for hierarchical imputation of categorical variables.}
\usage{
imp_cat_multi(y_imp, X_imp, Z_imp, clID, model_formula, nitt = 3000,
  thin = 10, burnin = 1000)
}
\arguments{
\item{y_imp}{A Vector with the variable to impute.}

\item{X_imp}{A data.frame with the fixed effects variables.}

\item{Z_imp}{A data.frame with the random effects variables.}

\item{clID}{A vector with the cluster ID.}

\item{model_formula}{A \code{\link[stats]{formula}} used for the analysis model.}

\item{nitt}{An integer defining number of MCMC iterations (see MCMCglmm).}

\item{thin}{An integer defining the thinning interval (see MCMCglmm).}

\item{burnin}{An integer defining the percentage of draws from the gibbs sampler
that should be discarded as burn in (see MCMCglmm).}
}
\value{
A n x 1 data.frame with the original and imputed values.
}
\description{
The function is called by the wrapper and relies on \code{MCMCglmm}.\cr
While in the single level function (\code{imp_cat_single}) we used regression trees
to impute data, here we run a multilevel multinomial model.
The basic idea is that for each category of the target variable (expect the reference category)
an own formula is set up, saying for example that the chances to end up in category
j increase with increasing X5. So there is an own regression coefficient \eqn{beta_{5,j}} present.
In a multilevel setting, this regression coefficient \eqn{beta_{5,j}} might be different for
different clusters: for cluster 27 it would be \eqn{beta_{5,j,27} = beta_{5,j} + u_{5,27}}.
This also leads to own random effect covariance matrices for each category.
All those random effect variance parameters can be collected
in one (quite large) covariance matrix where (for example)
not only the random intercepts variance and random slopes variance and their covariance
is present. Instead, there is even a covariance between the random slopes in category s
and the random intercepts in category p. Beside the difficulties in interpretation,
these covariances have shown to be numerically instable so they are set to be 0.
}
