% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMmHMM.R
\name{fitBM_mhmm}
\alias{fitBM_mhmm}
\title{Baum-Welch Function for multivariate data}
\usage{
fitBM_mhmm(hmm)
}
\arguments{
\item{hmm}{a hmm object obtained from set.mhmm}
}
\value{
The function returns all the parameters of a HMM, computed via Baum-Welch algorithm: the vector of initial probabilities, the transition matrix, the parameters of the distributions related to the states and the value of the log-likelihood.
}
\description{
This function is based on an EM algorithm (the Baum-Welch algorithm) and computes the parameters of a HMM for functional data, returning an object of \code{S3} class \code{mhmm}.
}
\examples{
data(copulahmmdata)
Obs <- copulahmmdata
n <- 20 #number of observations per statistical unit
n_tot <- dim(Obs)[1]
bt <- seq(1, n_tot, by = n)
distr <- c("exp", "gaussian")
#Initialize the HMM
hmm <- set_mhmm(Obs, bT = bt, nStates = 2, distr = distr)

# Compute the parameters of the HMM with the Baum-Welch algorithm
bw <- fitBM_mhmm(hmm)
}
\references{
Martino A., Guatteri, G. and Paganoni A. M., Multivariate Hidden Markov Models for disease progression, Mox Report 59/2018, 2018
}
