% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extra_viz.R
\name{emissions_map}
\alias{emissions_map}
\title{Download and plot essential climate data}
\usage{
emissions_map(
  print = TRUE,
  since = 1900,
  number = "all",
  title = expression("1900-2021 Cumulative " * CO[2] * " Emissions by Country")
)
}
\arguments{
\item{print}{(boolean) Display emissions treemap, defaults to TRUE. Use FALSE to not display chart.}

\item{since}{(numeric) Start year for cumulative emissions, defaults to 1900 if omitted}

\item{number}{(numeric) Number of countries to display in treemap, defaults to all if omitted}

\item{title}{(string) Manually specify chart title}
}
\value{
Invisibly returns a ggplot2 object with emissions treemap
}
\description{
Plots a treemap of cumulative co2 emissions by country since 1900.
}
\details{
\code{emissions_map} invisibly returns a ggplot2 object with cumulative emissions treemap by country since 1900 from \code{get_emissions}.
By default the chart is also displayed. Users may further modify the output ggplot2 chart.
}
\examples{
\donttest{
# Draw treemap

co2map <- emissions_map()

co2map <- emissions_map(since=2000, number=20, title="Top 20 Cumulative Emitters Since 2000")}

}
\author{
Hernando Cortina, \email{hch@alum.mit.edu}
}
