% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcVolatility.R
\name{calcSeriesVolatility}
\alias{calcSeriesVolatility}
\title{Calculate volatility of a series of indexes}
\usage{
calcSeriesVolatility(series_obj, window = 3, smooth = FALSE, ...)
}
\arguments{
\item{series_obj}{Series object to be calculated}

\item{window}{default = 3; Rolling periods over which to calculate the volatility}

\item{smooth}{default = FALSE; Also calculate volatilities for smoothed indexes}

\item{...}{Additional Arguments}
}
\value{
`serieshpi` object
}
\description{
Calculates volatility over a (progressive) series of indexes
}
\section{Further Details}{

Leaving order blank default to a moving average with order 3.
}

\examples{

# Load example sales
 data(ex_sales)

 # Create Index
 rt_index <- rtIndex(trans_df = ex_sales,
                     periodicity = 'monthly',
                     min_date = '2010-06-01',
                     max_date = '2015-11-30',
                     adj_type = 'clip',
                     date = 'sale_date',
                     price = 'sale_price',
                     trans_id = 'sale_id',
                     prop_id = 'pinx',
                     estimator = 'robust',
                     log_dep = TRUE,
                     trim_model = TRUE,
                     max_period = 48,
                     smooth = FALSE)

 # Create Series (Suppressing messages do to small sample size of this example)
 suppressMessages(
    hpi_series <- createSeries(hpi_obj = rt_index,
                               train_period = 12))

 # Calculate series volatility
 series_vol <- calcSeriesVolatility(series_obj = hpi_series,
                                    window= 3)

}
