% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterize_1comp.R
\name{parameterize_1comp}
\alias{parameterize_1comp}
\title{Parameterize_1comp}
\usage{
parameterize_1comp(chem.cas = NULL, chem.name = NULL,
  species = "Human", default.to.human = F,
  adjusted.Funbound.plasma = T, regression = T,
  restrictive.clearance = T, well.stirred.correction = T,
  suppress.messages = F, clint.pvalue.threshold = 0.05,
  minimum.Funbound.plasma = 1e-04)
}
\arguments{
\item{chem.cas}{Either the chemical name or the CAS number must be
specified.}

\item{chem.name}{Either the chemical name or the CAS number must be
specified.}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{default.to.human}{Substitutes missing rat values with human values if
true.}

\item{adjusted.Funbound.plasma}{Uses adjusted Funbound.plasma when set to
TRUE along with volume of distribution calculated with this value.}

\item{regression}{Whether or not to use the regressions in calculating
partition coefficients in volume of distribution calculation.}

\item{restrictive.clearance}{In calculating elimination rate and hepatic
bioavailability, protein binding is not taken into account (set to 1) in
liver clearance if FALSE.}

\item{well.stirred.correction}{Uses correction in calculation of hepatic
clearance for well-stirred model if TRUE.  This assumes clearance relative
to amount unbound in whole blood instead of plasma, but converted to use
with plasma concentration.}

\item{suppress.messages}{Whether or not to suppress messages.}

\item{clint.pvalue.threshold}{Hepatic clearance for chemicals where the in
vitro clearance assay result has a p-values greater than the threshold are
set to zero.}

\item{minimum.Funbound.plasma}{Monte Carlo draws less than this value are set 
equal to this value (default is 0.0001 -- half the lowest measured Fup in our
dataset).}
}
\value{
\item{Vdist}{Volume of distribution, units of L/kg BW.}
\item{Fgutabs}{Fraction of the oral dose absorbed, i.e. the fraction of the
dose that enters the gutlumen.} \item{kelim}{Elimination rate, units of
1/h.} \item{hematocrit}{Percent volume of red blood cells in the blood.}
\item{kgutabs}{Rate chemical is absorbed, 1/h.}
\item{million.cells.per.gliver}{Millions cells per gram of liver tissue.}
\item{MW}{Molecular Weight, g/mol.} \item{Rblood2plasma}{The ratio of the
concentration of the chemical in the blood to the concentration in the
plasma. Not used in calculations but included for the conversion of plasma
outputs.} \item{hepatic.bioavailability}{Fraction of dose remaining after
first pass clearance, calculated from the corrected well-stirred model.}
\item{BW}{Body Weight, kg.}
}
\description{
This function initializes the parameters needed in the function solve_1comp.
}
\examples{

 parameters <- parameterize_1comp(chem.name='Bisphenol-A',species='Rat')
 parameters <- parameterize_1comp(chem.cas='80-05-7',restrictive.clearance=FALSE,
                                  species='rabbit',default.to.human=TRUE)
 out <- solve_1comp(parameters=parameters)

}
\author{
John Wambaugh
}
\keyword{Parameter}
