% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_weight_class.R
\name{get_weight_class}
\alias{get_weight_class}
\title{Given vectors of age, BMI, recumbent length, weight, and gender,
categorizes weight classes using CDC and WHO categories.}
\usage{
get_weight_class(age_years, age_months, bmi, recumlen, weight, gender)
}
\arguments{
\item{age_years}{A vector of
ages in years.}

\item{age_months}{A vector of ages in months.}

\item{bmi}{A vector of BMIs.}

\item{recumlen}{A vector of heights or recumbent lengths in cm.}

\item{weight}{A vector of body weights in kg.}

\item{gender}{A vector of genders (as 'Male' or 'Female').}
}
\value{
A character vector of weight classes. Each element will be one of
 'Underweight', 'Normal', 'Overweight', or 'Obese'.
}
\description{
Given vectors of age, BMI, recumbent length, weight, and gender,
categorizes weight classes using CDC and WHO categories.
}
\references{
Ring, Caroline L., et al. "Identifying populations sensitive to 
environmental chemicals by simulating toxicokinetic variability." Environment 
International 106 (2017): 105-118
}
\author{
Caroline Ring
}
\keyword{httk-pop}
